package jamezo97.clonecraft;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;

import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.SoundPool;
import net.minecraft.client.particle.EffectRenderer;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityTracker;
import net.minecraft.entity.ai.EntityLookHelper;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.EnumToolMaterial;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.util.IntHashMap;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Session;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;

/***
 * Reflection methods to grab private fields I need :)
 * @author James
 *
 */
public class Reflect {
	
	// IntHashMap trackedEntityIDs
	
	/***
	 * Grabs value from field and casts it to given class.
	 * @param value Instance to get field value from
	 * @param f Field to get
	 * @param ret Type to return
	 * @return
	 */
	public static <T extends Object> T get(Object value, Field f, Class<T> ret){
		try{
			return ret.cast(f.get(value));
		}catch(Exception e){
			e.printStackTrace();
		}
		return null;
	}
	
	public static <T extends Object> T execute(Method method, Class<T> ret, Object instance, Object... args){
		if(method != null){
			try{
				Object returned = method.invoke(instance, args);
				if(ret != null){
					return ret.cast(returned);
				}
			}catch(Exception e){
				e.printStackTrace();
			}
		}
		return null;
	}
	
	/**
	 * Tries to set the value of the field, in the instance 'object' to the value 'value'
	 * @param field Field to set.
	 * @param object Instance of object to set within.
	 * @param value Object to set to.
	 */
	public static void set(Field field, Object object, Object value){
		try{
			field.set(object, value);
		}catch(Exception e){
			e.printStackTrace();
		}
	}
	
	public static Field trackedEntityIDs, nameToSoundPoolEntriesMapping, trackedEntities, toolMaterial, isGamePaused, fxLayers,
	classToIDMapping, lookHelper, currentItemStack;
	
	
	public static Method func_110775_a/*Render.class, Out: ResoruceLocation, In: Entity, I assume it's "getTexture" or similar.*/;
	static{
		Side side = FMLCommonHandler.instance().getEffectiveSide();
		if(side == Side.CLIENT){
			loadClient();
		}
		loadBase();	
	}

	
	public static void loadBase(){
		trackedEntityIDs = getFieldByType(IntHashMap.class, EntityTracker.class, 0, "trackedEntityIDs");
		trackedEntities = getFieldByType(Set.class, EntityTracker.class, 0, "trackedEntity");
		toolMaterial = getFieldByType(EnumToolMaterial.class, ItemSword.class, 0, "toolMaterial");
		classToIDMapping = getFieldByType(Map.class, EntityList.class, 3, "classToIDMapping");
		lookHelper = getFieldByType(EntityLookHelper.class, EntityLiving.class, 0, "lookHelper");
		currentItemStack = getFieldByType(ItemStack.class, InventoryPlayer.class, 0, "currentItemStack");
		System.out.println("LOaded: " + currentItemStack);
		//classToIDMapping = getStaticMapByKeyObjType(EntityList.class, Class.class, Integer.class, "classToIDMapping");//getFieldByType(HashMap.class, EntityList.class, 3, "classToIDMapping");
	}
	
	public static void loadClient(){
		nameToSoundPoolEntriesMapping = getFieldByType(Map.class, SoundPool.class, 0, "nameToSoundPoolEntriesMapping");
		isGamePaused = getFieldTypeAfterFieldType(boolean.class, 0, Session.class, 0, Minecraft.class, "isGamePaused");
		fxLayers = getFieldByType(List[].class, EffectRenderer.class, 0, "fxLayers");
		func_110775_a = getMethod(Render.class, ResourceLocation.class, Entity.class);
	}
	
	private static Method getMethod(Class<?> baseClass, Class<?> output, Class<?>... inputs) {
		if(output == null){
			output = void.class;
		}
		if(inputs == null){
			inputs = new Class[0];
		}
		Method[] methods = baseClass.getDeclaredMethods();
		for(int a = 0; a < methods.length; a++){
			/*System.out.println(methods[a].getName());
			if(methods[a].getName().equals("func_110775_a")){
				System.out.println("Is");
			}*/
			Class outputType = methods[a].getReturnType();
			Class[] inputsType = methods[a].getParameterTypes();
			if(outputType.equals(output)){
				if(inputsType.length == inputs.length){
					boolean matched = true;
					for(int b = 0; b < inputsType.length; b++){
						if(inputsType[b] != inputs[b]){
							matched = false;
							break;
						}
					}
					if(matched){
						methods[a].setAccessible(true);
						return methods[a];
					}
				}
			}
		}
		return null;
	}

	/**
	 * Gets the {@value}
	 * @param type1
	 * @param type1Index
	 * @param type2
	 * @param type2Index
	 * @param string
	 * @return
	 */
	private static Field getFieldTypeAfterFieldType(Class<?> type1, int type1Index, Class<?> type2, int type2Index, Class<?> containingClass, String nameForError) {
		Field[] fields = containingClass.getDeclaredFields();
		for(int a = 0; a < fields.length; a++){
			Field field = fields[a];
			if(type2Index > -1){
				if(field.getType() == type2){
					type2Index--;
					continue;
				}
			}else{
				if(field.getType() == type1){
					type1Index--;
					if(type1Index < 0){
						field.setAccessible(true);
						return field;
					}
				}
			}
		}
		print(nameForError);
		return null;
	}

	/***
	 * Grab and return the field representing a value, print error message if it cannot be located.
	 * @param type The type of the field you are grabbing.
	 * @param from The class which the field is located within.
	 * @param typeIndex The index of the field, given that it is the correct type.
	 * @param nameForError The name of the field, just for clarity if it cannot be found.
	 * @return The asked field.
	 */
	public static Field getFieldByType(Class type, Class from, int typeIndex, String nameForError){
		Field[] fields = from.getDeclaredFields();
		for(int a = 0; a < fields.length; a++){
			if(fields[a].getType() == type){
				if(typeIndex == 0){
					fields[a].setAccessible(true);
					return fields[a];
				}else{
					typeIndex--;
				}
			}
		}
		print(nameForError);
		return null;
	}
	
	public static Map getStaticMapByKeyObjType(Class from, Class typeKey, Class typeValue, String nameForError){
		Field[] fields = from.getDeclaredFields();
		for(int a = 0; a < fields.length; a++){
			if(fields[a].getType() == Map.class){
				fields[a].setAccessible(true);
				try{
					Object o = fields[a].get(null);
					if(o != null && o instanceof Map){
						Iterator it = ((Map)o).entrySet().iterator();
						if(it.hasNext()){
							Object oEntry = it.next();
							if(oEntry != null && oEntry instanceof Entry){
								Entry entry = (Entry)oEntry;
								Object key = entry.getKey();
								Object value = entry.getValue();
								if(key != null && value != null){
									if(key.getClass() == typeKey && value.getClass() == typeValue){
										return (Map)o;
									}
								}
							}
						}
					}
				}catch(Exception e){
					e.printStackTrace();
				}
			}
		}
		print(nameForError);
		return null;
	}
	
	private static void print(String fieldName){
		Logger.error("Error: Cannot grab field '" + fieldName + "' through reflection. This may cause some issues!");
	}
	
	
	
	
	
	
	
	
	
	
	
	
	
	static HashMap<Class, Integer> classToIDMappingHASH = null;
	
	public static int getIdFromEntityClass(Class cl){
		if(classToIDMappingHASH == null){
			classToIDMappingHASH = (HashMap<Class, Integer>)Reflect.get(null, classToIDMapping, HashMap.class);
		}
		if(classToIDMappingHASH.containsKey(cl)){
			return classToIDMappingHASH.get(cl);
		}
		return -1;
	}

}
